clear;
clc;
fullScriptPath = matlab.desktop.editor.getActiveFilename();
[folderPath, ~, ~] = fileparts(fullScriptPath);
%% FILE1
%nomefile
file1 = 'C2_2025-05-06_11-21-58.txt';
% Define the names of the files you want to read
filename1 = fullfile(folderPath, file1);
% Importa i dati
data_import_1 = importdata(filename1,'\t');
% Visualizza i dati
data1=data_import_1.data(5:end,:);
disp(data_import_1);

%% GRAFICI

figure(1)
% durezuibe

subplot(3,1,1)
plot(data1(:,1)-data1(1,1)-200,data1(:,22),"--k", 'LineWidth', 1.5)
hold on
plot(data1(:,1)-data1(1,1)-200,data1(:,21),"k", 'LineWidth', 1.5)
hold on
grid on
xlabel('time [s]');
ylabel('NORD [m]');
legend('com','response', 'Location', 'northeast');
xlim([0 210])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
set(gcf, 'Position', [100, 100, 800, 600]) % [x, y, width, height]
ylim([-3 58])

subplot(3,1,2)
plot(data1(:,1)-data1(1,1)-200,data1(:,15),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('Velocity [feet/s]');
xlim([0 210])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z
ylim([731 772])
subplot(3,1,3)
plot(data1(:,1)-data1(1,1)-200,data1(:,23),"k", 'LineWidth', 1.5)
grid on
xlabel('time [s]');
ylabel('throttle [deg]');
xlim([0 210])
pbaspect([4 1 1]) % Aspect ratio X:Y:Z



